/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.plant;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Random;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesFruit;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesItem;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.rendering.utils.ColorMixer;

public class PlantSpecies {
    private String speciesName;
    private long speciesId;
    private PlantSpeciesType plantType;
    private boolean evergreen;
    private GameMaterial branchMaterial;
    private PlantSpeciesFruit fruit;
    private PlantSpeciesItem item;
    private String leafColorSwatch;
    private String branchColorSwatch;
    private String leafTransitionColorSwatch;
    private int minTileHeight;
    private int maxTileHeight;
    @JsonIgnore
    private final Array<Array<Color>> leafTransitionColors = new Array();
    @JsonIgnore
    private final Array<Color> leafColors = new Array();
    @JsonIgnore
    private final Array<Color> branchColors = new Array();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlantSpecies that = (PlantSpecies)o;
        return this.speciesId == that.speciesId;
    }

    public int hashCode() {
        return (int)this.speciesId;
    }

    public String getSpeciesName() {
        return this.speciesName;
    }

    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName;
    }

    public boolean isEvergreen() {
        return this.evergreen;
    }

    public void setEvergreen(boolean isEvergreen) {
        this.evergreen = isEvergreen;
    }

    public GameMaterial getBranchMaterial() {
        return this.branchMaterial;
    }

    public void setBranchMaterial(GameMaterial branchMaterial) {
        this.branchMaterial = branchMaterial;
    }

    public String getLeafTransitionColorSwatch() {
        return this.leafTransitionColorSwatch;
    }

    public void setLeafTransitionColorSwatch(String leafTransitionColorSwatch) {
        this.leafTransitionColorSwatch = leafTransitionColorSwatch;
    }

    public Array<Array<Color>> getLeafTransitionColors() {
        return this.leafTransitionColors;
    }

    public int getMinTileHeight() {
        return this.minTileHeight;
    }

    public void setMinTileHeight(int minTileHeight) {
        this.minTileHeight = minTileHeight;
    }

    public int getMaxTileHeight() {
        return this.maxTileHeight;
    }

    public void setMaxTileHeight(int maxTileHeight) {
        this.maxTileHeight = maxTileHeight;
    }

    public PlantSpeciesType getPlantType() {
        return this.plantType;
    }

    public void setPlantType(PlantSpeciesType plantType) {
        this.plantType = plantType;
    }

    public long getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(long speciesId) {
        this.speciesId = speciesId;
    }

    public String getLeafColorSwatch() {
        return this.leafColorSwatch;
    }

    public void setLeafColorSwatch(String leafColorSwatch) {
        this.leafColorSwatch = leafColorSwatch;
    }

    public String getBranchColorSwatch() {
        return this.branchColorSwatch;
    }

    public void setBranchColorSwatch(String branchColorSwatch) {
        this.branchColorSwatch = branchColorSwatch;
    }

    public Array<Color> getLeafColors() {
        return this.leafColors;
    }

    public Array<Color> getBranchColors() {
        return this.branchColors;
    }

    public Color randomLeafColor(Random random) {
        return this.randomColor(random, this.leafColors);
    }

    public Color randomBranchColor(Random random) {
        return this.randomColor(random, this.branchColors);
    }

    private Color randomColor(Random random, Array<Color> colorArray) {
        if (colorArray.size == 0) {
            return null;
        }
        return ColorMixer.randomBlend(random, colorArray);
    }

    public PlantSpeciesFruit getFruit() {
        return this.fruit;
    }

    public void setFruit(PlantSpeciesFruit fruit) {
        this.fruit = fruit;
    }

    public boolean hasFruit() {
        return this.fruit != null;
    }

    public PlantSpeciesItem getItem() {
        return this.item;
    }

    public void setItem(PlantSpeciesItem item) {
        this.item = item;
    }
}

